<?php

declare(strict_types=1);

ob_start();
ini_set('display_errors', 0);
ini_set('log_errors', 1);
error_reporting(E_ALL);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../db/db_connection.php';
require_once __DIR__ . '/../files/guardiankey.php';

if (!function_exists('sendJsonResponse')) {
    function sendJsonResponse(array $response, int $httpCode = 200): void
    {
        header('Content-Type: application/json');
        
        http_response_code($httpCode);
        if (ob_get_level() > 0) {
            ob_end_clean();
        }
        echo json_encode($response);
        exit;
    }
}