<?php
session_start();
require_once('db_connection.php'); // Conexión a la base de datos PDO

// 1. VERIFICAR QUE EL CLIENTE ESTÉ LOGUEADO Y QUE EL MÉTODO SEA POST
if (!isset($_SESSION['client_id']) || $_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: ../clients/login.php');
    exit();
}

// 2. OBTENER Y SANITIZAR LOS DATOS DEL FORMULARIO
$client_id = $_POST['client_id'];
$service_date = filter_input(INPUT_POST, 'service_date', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$subject = filter_input(INPUT_POST, 'report_subject', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$details = filter_input(INPUT_POST, 'report_details', FILTER_SANITIZE_FULL_SPECIAL_CHARS);

// Seguridad: Verificar que el ID del formulario coincida con el de la sesión
if ($client_id != $_SESSION['client_id']) {
    $_SESSION['feedback'] = ['type' => 'error', 'message' => 'Security validation error.'];
    // Redirigir de vuelta a la sección de quejas
    header('Location: ../clients/dashboard.php#complaints');
    exit();
}

// Validación simple para asegurar que los campos no estén vacíos
if (empty($service_date) || empty($subject) || empty($details)) {
    $_SESSION['feedback'] = ['type' => 'error', 'message' => 'Please fill out all required fields.'];
    header('Location: ../clients/dashboard.php#complaints');
    exit();
}

// 3. PREPARAR LOS DATOS PARA LA BASE DE DATOS
// Combinamos la fecha del servicio con los detalles para no perder esa información.
$full_description = "Service Date: " . $service_date . "\n\n" . $details;

// 4. EJECUTAR LA INSERCIÓN EN LA BASE DE DATOS
try {
    // El estado por defecto 'Recibido' se asigna automáticamente en la BD.
    $stmt = $pdo->prepare(
        "INSERT INTO complaints (client_id, title, description, status) 
         VALUES (?, ?, ?, 'Recibido')"
    );
    
    $stmt->execute([
        $client_id, 
        $subject, 
        $full_description
    ]);

    // 5. PREPARAR MENSAJE DE ÉXITO Y REDIRIGIR
    $_SESSION['feedback'] = ['type' => 'success', 'message' => 'Report submitted successfully! We will review it shortly.'];

} catch (PDOException $e) {
    // Manejo de errores de la base de datos
    error_log("Error creating complaint: " . $e->getMessage());
    $_SESSION['feedback'] = ['type' => 'error', 'message' => 'An error occurred while submitting your report. Please try again.'];
}

// Redirigir siempre de vuelta a la sección de quejas del dashboard
header('Location: ../clients/dashboard.php#complaints');
exit();
?>