<?php
// --- Desactivar errores en producción ---
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);
// --- --- ---

// Pon tu llave secreta
$API_KEY = 'MWxjQ-HHzZ1pfWPr.ykIEk_7Dcl6UvnJ5ia0JbsscFUibIYWXvqQRFbvJzW3MzBxK';

// ------------------------------------------------------------------------------------------------------
// CORRECCIÓN: La URL debe apuntar al script que captura los datos de éxito y redirige (payment-data.php).
// ------------------------------------------------------------------------------------------------------
$returnUrl = 'https://crm.tunegociolocal.com/payment-data.php';

// --- ARREGLO FINAL: USAMOS EL HOST CORRECTO SIN /API/V1 ---
$BASE_URL = 'https://live.dodopayments.com';

// -------------------------------------------------
// El botón de pago manual en account.php pasa type=monthly
$type = isset($_GET['type']) ? $_GET['type'] : 'setup';
$products = [
    'setup'     => 'pdt_ynNjxLG3Ut3mFPMZKYgLQ', 
    'monthly' => 'pdt_a8tOOqcMl5kCJtDlZK3q4', // Usamos este producto para la renovación
];
$productId = isset($products[$type]) ? $products[$type] : $products['setup'];

$payload = json_encode([
    'product_cart' => [
        [ 'product_id' => $productId, 'quantity' => 1 ],
    ],
    // Se asegura que el return_url es payment-data.php
    'return_url' => $returnUrl,
]);

$ch = curl_init();
// Usamos el endpoint '/checkouts'
curl_setopt($ch, CURLOPT_URL, $BASE_URL . '/checkouts');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer {$API_KEY}",
    "Content-Type: application/json"
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 20);

$res = curl_exec($ch);
$curl_error_message = curl_error($ch);
curl_close($ch);

$data = $res ? json_decode($res, true) : null;

if (!empty($data['checkout_url'])) {
    header('Location: ' . $data['checkout_url']);
    exit;
}

// Si algo falla, muestra un error genérico y loguea la respuesta de Dodo
http_response_code(500);
echo 'Error: No se pudo crear la sesión de pago. Contacte a soporte.';
if ($curl_error_message) {
    error_log("Dodo Pay cURL Error (Checkouts): " . $curl_error_message);
} else {
    error_log("Dodo Pay API Error (Checkouts): " . $res);
}
?>