<?php
/**
 * PASTORAL PORTAL - GESTIÓN INTEGRAL PARA IGLESIAS
 * Basado en la arquitectura Live Ops Center
 */

// 1. Simulación de Autenticación y Configuración
// En producción, esto conectaría a la DB real. Aquí simulamos los datos para la demo.
$user_id = 1;
$client_info = [
    'business_name' => 'Iglesia Vida Nueva',
    'logo_url' => 'https://cdn-icons-png.flaticon.com/512/2664/2664627.png' // Icono de iglesia genérico
];

// 2. MOCK DATA (Simulando base de datos de Iglesia)

// A. MIEMBROS (Antes Staff)
$members = [
    [
        'id' => 1, 'name' => 'Hno. Juan Pérez', 'role' => 'Líder de Alabanza', 'status' => 'Activo', 
        'photo' => 'https://i.pravatar.cc/150?u=1', 'last_attendance' => 'Domingo pasado',
        'spiritual_status' => 'Bautizado'
    ],
    [
        'id' => 2, 'name' => 'Hna. María Lopez', 'role' => 'Maestra de Niños', 'status' => 'Activo', 
        'photo' => 'https://i.pravatar.cc/150?u=5', 'last_attendance' => 'Hace 2 semanas',
        'spiritual_status' => 'En Discipulado'
    ],
    [
        'id' => 3, 'name' => 'Carlos Ruiz', 'role' => 'Ujier', 'status' => 'Inactivo', 
        'photo' => 'https://i.pravatar.cc/150?u=3', 'last_attendance' => 'Hace 1 mes',
        'spiritual_status' => 'Visitante'
    ],
];

// B. PETICIONES Y VISITAS (Antes Citas)
$ministry_tasks = [
    [
        'id' => 1, 'type' => 'Oración', 'title' => 'Salud de Familia García', 'member' => 'Familia García',
        'date' => date('Y-m-d'), 'time' => '19:00', 'status' => 'pending', 'assigned_to' => 'Pastor General'
    ],
    [
        'id' => 2, 'type' => 'Visita', 'title' => 'Visita Hospitalaria', 'member' => 'Hno. Roberto',
        'date' => date('Y-m-d'), 'time' => '15:30', 'status' => 'confirmed', 'assigned_to' => 'Líder de Diáconos'
    ],
    [
        'id' => 3, 'type' => 'Consejería', 'title' => 'Consejería Matrimonial', 'member' => 'Esposos Torres',
        'date' => date('Y-m-d', strtotime('+1 day')), 'time' => '18:00', 'status' => 'confirmed', 'assigned_to' => 'Pastor General'
    ]
];

// C. FINANZAS (Antes Leads/Marketing)
$finances = [
    ['id' => 1, 'type' => 'Diezmo', 'amount' => 150.00, 'donor' => 'Juan Pérez', 'date' => 'Hoy', 'method' => 'Transferencia'],
    ['id' => 2, 'type' => 'Ofrenda', 'amount' => 45.50, 'donor' => 'Anónimo', 'date' => 'Hoy', 'method' => 'Efectivo'],
    ['id' => 3, 'type' => 'Pro-Templo', 'amount' => 500.00, 'donor' => 'Familia Méndez', 'date' => 'Ayer', 'method' => 'Cheque'],
];

// D. SERMONES (Media)
$sermons = [
    ['id' => 1, 'title' => 'La Fe que Mueve Montañas', 'preacher' => 'Pastor Principal', 'date' => 'Domingo 12', 'duration' => '45:10'],
    ['id' => 2, 'title' => 'Venciendo el Temor', 'preacher' => 'Hno. Invitado', 'date' => 'Domingo 05', 'duration' => '38:20'],
];

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Pastoral Portal - <?php echo htmlspecialchars($client_info['business_name']); ?></title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;700;900&display=swap" rel="stylesheet">

    <style>
        :root {
            --color-primary: #1e3a8a; /* Azul Espiritual */
            --color-secondary: #d97706; /* Dorado/Ambar */
            --color-bg: #f8fafc;
            --color-card: #ffffff;
        }
        
        body { font-family: 'Inter', sans-serif; background-color: var(--color-bg); touch-action: manipulation; }
        * { -webkit-tap-highlight-color: transparent; }

        .animate-slide-in { animation: slideIn 0.4s ease-out forwards; }
        @keyframes slideIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .tab-btn.active {
            color: var(--color-primary);
            border-bottom-color: var(--color-secondary);
            background-color: #eff6ff;
        }
        .tab-content { display: none; }
        .tab-content.active { display: block; }
        
        /* Hide Scrollbar */
        .no-scrollbar::-webkit-scrollbar { display: none; }
        .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }
    </style>
</head>
<body class="min-h-screen flex flex-col pb-20">

    <!-- OVERLAY QR PARA ESCRITORIO -->
    <div class="hidden lg:flex fixed inset-0 z-[100] bg-slate-900/95 backdrop-blur-sm flex-col items-center justify-center text-center p-8">
        <div class="bg-white p-10 rounded-3xl shadow-2xl max-w-md w-full border-4 border-[var(--color-primary)] animate-slide-in">
            <div class="mb-6 flex justify-center">
                <div class="p-4 bg-blue-50 rounded-full">
                    <i data-lucide="church" class="w-12 h-12 text-[var(--color-primary)]"></i>
                </div>
            </div>
            <h2 class="text-3xl font-black text-slate-800 mb-2 uppercase tracking-tight">Modo Pastor Móvil</h2>
            <p class="text-slate-500 mb-8 font-medium">Administra tu congregación desde la palma de tu mano.</p>
            <div class="bg-white p-4 rounded-xl shadow-inner border border-slate-200 inline-block mb-6 relative">
                <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=PastoralPortalDemo" alt="QR" class="w-48 h-48 mix-blend-multiply">
            </div>
        </div>
    </div>

    <!-- HEADER -->
    <header class="bg-white shadow-sm sticky top-0 z-40 border-b-2 border-[var(--color-secondary)]">
        <div class="max-w-7xl mx-auto px-4 py-3 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="bg-[var(--color-primary)] p-1.5 rounded-lg">
                    <i data-lucide="cross" class="w-6 h-6 text-white"></i>
                </div>
                <div>
                    <h1 class="text-lg font-black text-[var(--color-primary)] uppercase leading-none tracking-tight">
                        Pastoral Portal
                    </h1>
                    <p class="text-[10px] font-bold text-[var(--color-secondary)] uppercase tracking-wider">Iglesia Conectada</p>
                </div>
            </div>
            <div class="flex items-center gap-2">
                 <button class="bg-slate-100 p-2 rounded-full text-slate-600 hover:bg-slate-200 transition relative">
                    <span class="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full"></span>
                    <i data-lucide="bell" class="w-5 h-5"></i>
                </button>
            </div>
        </div>
        
        <!-- TABS -->
        <div class="bg-white border-t border-slate-100 overflow-x-auto no-scrollbar sticky top-[60px] z-30">
            <nav class="flex min-w-full px-2" aria-label="Tabs">
                <button onclick="switchTab('membresia')" id="btn-membresia" class="tab-btn active flex-1 py-3 border-b-4 border-transparent font-bold text-xs text-slate-500 flex flex-col items-center gap-1 uppercase min-w-[80px]">
                    <i data-lucide="users" class="w-5 h-5"></i> Miembros
                </button>
                <button onclick="switchTab('ministerio')" id="btn-ministerio" class="tab-btn flex-1 py-3 border-b-4 border-transparent font-bold text-xs text-slate-500 flex flex-col items-center gap-1 uppercase min-w-[80px]">
                    <i data-lucide="heart-handshake" class="w-5 h-5"></i> Pastoral
                </button>
                <button onclick="switchTab('finanzas')" id="btn-finanzas" class="tab-btn flex-1 py-3 border-b-4 border-transparent font-bold text-xs text-slate-500 flex flex-col items-center gap-1 uppercase min-w-[80px]">
                    <i data-lucide="coins" class="w-5 h-5"></i> Finanzas
                </button>
                <button onclick="switchTab('recursos')" id="btn-recursos" class="tab-btn flex-1 py-3 border-b-4 border-transparent font-bold text-xs text-slate-500 flex flex-col items-center gap-1 uppercase min-w-[80px]">
                    <i data-lucide="sparkles" class="w-5 h-5"></i> IA & Web
                </button>
            </nav>
        </div>
    </header>

    <main class="flex-grow p-4 max-w-7xl mx-auto w-full">
        
        <!-- PESTAÑA 1: MEMBRESÍA -->
        <div id="tab-membresia" class="tab-content active animate-slide-in">
            <div class="bg-blue-50 rounded-xl p-4 mb-6 border border-blue-100 flex justify-between items-center">
                <div>
                    <h2 class="text-xl font-black text-[var(--color-primary)]">Membresía</h2>
                    <p class="text-xs text-blue-600 font-medium">320 Miembros Activos</p>
                </div>
                <button class="bg-[var(--color-primary)] text-white p-2 rounded-lg shadow-lg active:scale-95">
                    <i data-lucide="user-plus" class="w-5 h-5"></i>
                </button>
            </div>

            <div class="grid grid-cols-1 gap-4 mb-20">
                <?php foreach($members as $m): ?>
                <div class="bg-white p-4 rounded-xl shadow-sm border border-slate-100 flex items-center gap-4">
                    <img src="<?php echo $m['photo']; ?>" class="w-12 h-12 rounded-full object-cover border-2 border-[var(--color-secondary)]">
                    <div class="flex-1">
                        <h3 class="font-bold text-slate-800"><?php echo $m['name']; ?></h3>
                        <p class="text-xs text-slate-500 uppercase font-bold"><?php echo $m['role']; ?></p>
                        <div class="flex items-center gap-2 mt-1">
                            <span class="bg-slate-100 text-slate-600 text-[10px] px-2 py-0.5 rounded-full font-bold uppercase"><?php echo $m['spiritual_status']; ?></span>
                        </div>
                    </div>
                    <button class="text-slate-300 hover:text-[var(--color-primary)]">
                        <i data-lucide="more-vertical" class="w-5 h-5"></i>
                    </button>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- PESTAÑA 2: MINISTERIO (Pastoral) -->
        <div id="tab-ministerio" class="tab-content animate-slide-in">
            <div class="mb-6">
                <h2 class="text-lg font-black text-slate-700 uppercase mb-4 flex items-center gap-2">
                    <i data-lucide="calendar" class="w-5 h-5 text-[var(--color-secondary)]"></i> Agenda Pastoral
                </h2>
                
                <div class="space-y-4">
                    <?php foreach($ministry_tasks as $task): ?>
                    <div class="bg-white p-4 rounded-xl shadow-sm border-l-4 <?php echo $task['status'] === 'pending' ? 'border-yellow-400' : 'border-green-500'; ?> border-t border-r border-b border-slate-100">
                        <div class="flex justify-between items-start mb-2">
                            <span class="text-[10px] font-black uppercase bg-slate-100 text-slate-600 px-2 py-1 rounded"><?php echo $task['type']; ?></span>
                            <span class="text-xs font-bold text-[var(--color-primary)]"><?php echo $task['time']; ?></span>
                        </div>
                        <h3 class="font-bold text-lg text-slate-800 leading-tight mb-1"><?php echo $task['title']; ?></h3>
                        <p class="text-sm text-slate-500 mb-3 flex items-center gap-1">
                            <i data-lucide="user" class="w-3 h-3"></i> <?php echo $task['member']; ?>
                        </p>
                        <div class="flex gap-2">
                            <button class="flex-1 bg-slate-50 text-slate-600 py-2 rounded-lg text-xs font-bold uppercase border border-slate-200">Reagendar</button>
                            <button class="flex-1 bg-[var(--color-primary)] text-white py-2 rounded-lg text-xs font-bold uppercase shadow-md">Completar</button>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="bg-indigo-50 rounded-xl p-4 border border-indigo-100">
                <h3 class="font-bold text-indigo-900 mb-2 flex items-center gap-2">
                    <i data-lucide="users" class="w-4 h-4"></i> Departamentos
                </h3>
                <div class="grid grid-cols-2 gap-2">
                    <div class="bg-white p-3 rounded-lg text-center shadow-sm">
                        <p class="text-xs text-slate-400 font-bold uppercase">Ujieres</p>
                        <p class="font-black text-indigo-600">12 Asignados</p>
                    </div>
                    <div class="bg-white p-3 rounded-lg text-center shadow-sm">
                        <p class="text-xs text-slate-400 font-bold uppercase">Alabanza</p>
                        <p class="font-black text-indigo-600">8 Asignados</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- PESTAÑA 3: FINANZAS -->
        <div id="tab-finanzas" class="tab-content animate-slide-in">
            <div class="bg-gradient-to-r from-slate-900 to-slate-800 rounded-2xl p-6 text-white shadow-xl mb-6 relative overflow-hidden">
                <div class="absolute top-0 right-0 p-4 opacity-10">
                    <i data-lucide="coins" class="w-24 h-24 text-white"></i>
                </div>
                <p class="text-slate-400 text-xs font-bold uppercase mb-1">Entradas del Mes</p>
                <h2 class="text-4xl font-black mb-4">$4,250.00</h2>
                <div class="flex gap-2 text-xs font-medium">
                    <span class="bg-green-500/20 text-green-300 px-2 py-1 rounded">+12% vs mes anterior</span>
                </div>
            </div>

            <h3 class="font-black text-slate-700 uppercase mb-3 text-sm">Últimos Movimientos</h3>
            <div class="space-y-3 mb-20">
                <?php foreach($finances as $f): ?>
                <div class="bg-white p-4 rounded-xl border border-slate-100 flex justify-between items-center shadow-sm">
                    <div class="flex items-center gap-3">
                        <div class="bg-green-50 p-2 rounded-full text-green-600">
                            <i data-lucide="arrow-down-left" class="w-5 h-5"></i>
                        </div>
                        <div>
                            <p class="font-bold text-slate-800"><?php echo $f['type']; ?></p>
                            <p class="text-[10px] text-slate-400 font-bold uppercase"><?php echo $f['donor']; ?> • <?php echo $f['method']; ?></p>
                        </div>
                    </div>
                    <span class="font-black text-slate-800">+$<?php echo number_format($f['amount'], 2); ?></span>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- PESTAÑA 4: RECURSOS E IA -->
        <div id="tab-recursos" class="tab-content animate-slide-in">
            
            <!-- Herramientas IA -->
            <div class="mb-8">
                <h2 class="text-lg font-black text-slate-700 uppercase mb-4 flex items-center gap-2">
                    <i data-lucide="sparkles" class="w-5 h-5 text-[var(--color-secondary)]"></i> IA Pastoral
                </h2>
                <div class="grid grid-cols-2 gap-3">
                    <button class="bg-white p-4 rounded-xl border border-indigo-100 shadow-sm text-left hover:border-[var(--color-primary)] transition group">
                        <div class="bg-indigo-50 w-10 h-10 rounded-lg flex items-center justify-center mb-3 group-hover:bg-[var(--color-primary)] group-hover:text-white transition">
                            <i data-lucide="pen-tool" class="w-5 h-5 text-indigo-600 group-hover:text-white"></i>
                        </div>
                        <p class="font-bold text-sm text-slate-700">Creador de Bosquejos</p>
                        <p class="text-[10px] text-slate-400 mt-1">Genera sermones estructurados en segundos.</p>
                    </button>
                    
                    <button class="bg-white p-4 rounded-xl border border-indigo-100 shadow-sm text-left hover:border-[var(--color-primary)] transition group">
                        <div class="bg-purple-50 w-10 h-10 rounded-lg flex items-center justify-center mb-3 group-hover:bg-purple-600 group-hover:text-white transition">
                            <i data-lucide="languages" class="w-5 h-5 text-purple-600 group-hover:text-white"></i>
                        </div>
                        <p class="font-bold text-sm text-slate-700">Traductor Bíblico</p>
                        <p class="text-[10px] text-slate-400 mt-1">Traduce recursos del inglés al español.</p>
                    </button>

                     <button class="bg-white p-4 rounded-xl border border-indigo-100 shadow-sm text-left hover:border-[var(--color-primary)] transition group">
                        <div class="bg-orange-50 w-10 h-10 rounded-lg flex items-center justify-center mb-3 group-hover:bg-orange-500 group-hover:text-white transition">
                            <i data-lucide="mail" class="w-5 h-5 text-orange-500 group-hover:text-white"></i>
                        </div>
                        <p class="font-bold text-sm text-slate-700">Generador de Cartas</p>
                        <p class="text-[10px] text-slate-400 mt-1">Cartas de bienvenida y consolidación.</p>
                    </button>

                    <button class="bg-white p-4 rounded-xl border border-indigo-100 shadow-sm text-left hover:border-[var(--color-primary)] transition group">
                        <div class="bg-green-50 w-10 h-10 rounded-lg flex items-center justify-center mb-3 group-hover:bg-green-600 group-hover:text-white transition">
                            <i data-lucide="check-circle" class="w-5 h-5 text-green-600 group-hover:text-white"></i>
                        </div>
                        <p class="font-bold text-sm text-slate-700">Corrector</p>
                        <p class="text-[10px] text-slate-400 mt-1">Revisión ortográfica de boletines.</p>
                    </button>
                </div>
            </div>

            <!-- Audio Predicas -->
            <div class="mb-8">
                <div class="flex justify-between items-center mb-4">
                    <h2 class="text-lg font-black text-slate-700 uppercase flex items-center gap-2">
                        <i data-lucide="mic" class="w-5 h-5 text-[var(--color-secondary)]"></i> Predicas (Audio)
                    </h2>
                    <span class="text-[10px] font-bold bg-slate-100 px-2 py-1 rounded">2 / 12 Usadas</span>
                </div>
                
                <div class="space-y-3">
                    <?php foreach($sermons as $sermon): ?>
                    <div class="bg-white p-3 rounded-lg border border-slate-100 flex items-center gap-3 shadow-sm">
                        <div class="bg-slate-800 w-10 h-10 rounded-full flex items-center justify-center text-white flex-shrink-0">
                            <i data-lucide="play" class="w-4 h-4 fill-current"></i>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="font-bold text-sm text-slate-800 truncate"><?php echo $sermon['title']; ?></p>
                            <p class="text-[10px] text-slate-500 font-bold uppercase"><?php echo $sermon['preacher']; ?></p>
                        </div>
                        <span class="text-[10px] font-mono text-slate-400"><?php echo $sermon['duration']; ?></span>
                    </div>
                    <?php endforeach; ?>
                    
                    <button class="w-full py-3 border-2 border-dashed border-slate-300 rounded-lg text-slate-400 font-bold uppercase text-xs hover:border-[var(--color-primary)] hover:text-[var(--color-primary)] transition">
                        + Subir Nueva Predica
                    </button>
                </div>
            </div>
            
            <!-- Cafe Network -->
            <div class="bg-[var(--color-secondary)] rounded-xl p-4 text-white shadow-lg mb-20 relative overflow-hidden">
                <i data-lucide="coffee" class="absolute -right-4 -bottom-4 w-32 h-32 text-white/20 transform rotate-12"></i>
                <h3 class="font-black text-xl uppercase mb-1">Cafe Network</h3>
                <p class="text-white/80 text-xs font-medium mb-4 max-w-[70%]">Reunión virtual mensual con todos los miembros y líderes.</p>
                <button class="bg-white text-[var(--color-secondary)] px-4 py-2 rounded-lg text-xs font-black uppercase shadow-sm">
                    Ver Calendario
                </button>
            </div>

        </div>
        
        <!-- FAB: Crear Nuevo -->
        <button class="fixed bottom-6 right-6 bg-[var(--color-secondary)] text-white w-14 h-14 rounded-full shadow-2xl hover:scale-110 transition z-50 flex items-center justify-center border-4 border-white animate-bounce active:scale-90">
            <i data-lucide="plus" class="w-8 h-8"></i>
        </button>

    </main>

    <!-- Bottom Nav para Web Pública (Simulado) -->
    <div class="fixed bottom-0 left-0 right-0 bg-white border-t border-slate-200 p-2 flex justify-center lg:hidden z-20">
        <p class="text-[10px] text-slate-400 font-medium">Vista Admin • <a href="#" class="text-[var(--color-primary)] font-bold">Ver Web Pública</a></p>
    </div>

<script>
    lucide.createIcons();

    function switchTab(tabId) {
        document.querySelectorAll('.tab-content').forEach(el => {
            el.classList.remove('active');
            el.classList.remove('animate-slide-in'); 
        });
        document.querySelectorAll('.tab-btn').forEach(btn => {
            btn.classList.remove('active');
        });

        const selectedContent = document.getElementById('tab-' + tabId);
        if(selectedContent) {
            selectedContent.classList.add('active');
            void selectedContent.offsetWidth; 
            selectedContent.classList.add('animate-slide-in');
        }

        const selectedBtn = document.getElementById('btn-' + tabId);
        if(selectedBtn) {
            selectedBtn.classList.add('active');
            selectedBtn.scrollIntoView({ behavior: 'smooth', block: 'nearest', inline: 'center' });
        }
    }
</script>
</body>
</html>