<?php

$docs_videos = [
    // --- DASHBOARD (VIDEO) ---
    'docs-dashboard' => [
        'id'          => 'docs-dashboard',
        'title'       => 'MANUALES DE CRECIMIENTO',
        'description' => 'Colección maestra de documentos y guías estratégicas para escalar tu negocio.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/DocsDashboard.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/DocsDashboard.webp',
    ],

    // --- MANUALES (AUDIOS) ---
    'docs-awareness-levels' => [
        'id'          => 'docs-awareness-levels',
        'title'       => 'NIVELES DE CONCIENCIA',
        'description' => 'Audio Lección: Entiende qué tanto sabe tu cliente sobre su problema y tu solución (Eugene Schwartz).',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/audios/AwarenessLevels.mp3',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/AwarenessLevels.webp',
    ],
    'docs-customer-journey' => [
        'id'          => 'docs-customer-journey',
        'title'       => 'CUSTOMER JOURNEY',
        'description' => 'Audio Lección: El recorrido completo de tu cliente, desde que te descubre hasta que te compra.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/audios/CustomerJourney.mp3',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/CustomerJourney.webp',
    ],
    'docs-acquisition-cycle' => [
        'id'          => 'docs-acquisition-cycle',
        'title'       => 'CICLO DE ADQUISICIÓN',
        'description' => 'Audio Lección: Las fases clave para atraer desconocidos y convertirlos en prospectos calificados.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/audios/AcquisitionCycle.mp3',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/AcquisitionCycle.webp',
    ],
    'docs-touchpoints' => [
        'id'          => 'docs-touchpoints',
        'title'       => 'PUNTOS DE CONTACTO',
        'description' => 'Audio Lección: Optimización de cada interacción crítica entre tu marca y el usuario.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/audios/Touchpoints.mp3',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/Touchpoints.webp',
    ],
    'docs-ideal-client' => [
        'id'          => 'docs-ideal-client',
        'title'       => 'PERFIL DEL CLIENTE IDEAL',
        'description' => 'Audio Lección: Cómo definir y verificar el avatar que realmente paga por tus servicios.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/audios/IdealClient.mp3',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/IdealClient.webp',
    ],
    'docs-transformation-table' => [
        'id'          => 'docs-transformation-table',
        'title'       => 'TABLA DE TRANSFORMACIÓN',
        'description' => 'Audio Lección: Herramienta para mapear el "Antes" y "Después" de tu cliente (Estado Actual vs. Deseado).',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/audios/TransformationTable.mp3',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/TransformationTable.webp',
    ],
    'docs-emotional-marketing' => [
        'id'          => 'docs-emotional-marketing',
        'title'       => 'MARKETING EMOCIONAL',
        'description' => 'Audio Lección: Cómo conectar con los sentimientos profundos para impulsar decisiones de compra.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/audios/EmotionalMarketing.mp3',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/EmotionalMarketing.webp',
    ],
    'docs-market-trends' => [
        'id'          => 'docs-market-trends',
        'title'       => 'TENDENCIAS DEL MERCADO',
        'description' => 'Audio Lección: Análisis de lo que está moviendo el mercado actualmente y cómo aprovecharlo.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/audios/MarketTrends.mp3',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/MarketTrends.webp',
    ],
];

function get_docs_video_by_id(string $video_id): ?array {
    global $docs_videos;
    return $docs_videos[$video_id] ?? null;
}