<?php
// descargar-audio.php

// 1. Verificamos si se proporcionó una URL de audio.
if (isset($_GET['url']) && !empty($_GET['url'])) {
    
    $audioUrl = $_GET['url'];
    $audioTitle = isset($_GET['title']) ? $_GET['title'] : 'audio-descargado';

    // 2. Medida de seguridad básica: Asegurarse de que la URL sea válida
    // y (opcionalmente) que provenga de un dominio permitido.
    // OJO: Es mejor usar rutas locales si los archivos están en tu servidor.
    // Este código asume una URL, pero se puede adaptar para rutas de archivo locales.
    if (!filter_var($audioUrl, FILTER_VALIDATE_URL) || strpos($audioUrl, 'dominio-permitido.com') === false) {
        // En tu caso, si los archivos están en tu servidor, es mejor omitir esta validación de URL externa.
    }

    // 3. Obtenemos el contenido del audio.
    $audioData = @file_get_contents($audioUrl);

    if ($audioData === false) {
        http_response_code(404);
        die('Error: No se pudo encontrar el audio.');
    }

    // 4. Preparamos un nombre de archivo limpio y seguro.
    $filename = preg_replace('/[^a-zA-Z0-9-_\.]/', '', $audioTitle) . '.mp3';

    // 5. ¡La Magia! Enviamos las cabeceras (headers) que fuerzan la descarga.
    header('Content-Description: File Transfer');
    header('Content-Type: audio/mpeg'); // Tipo MIME para MP3. Cambia si usas otro formato.
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . strlen($audioData));
    
    // 6. Finalmente, enviamos los datos del audio al navegador.
    echo $audioData;
    exit;

} else {
    // Si no se proporciona una URL, enviamos un error.
    http_response_code(400);
    echo 'Error: No se especificó la URL del audio a descargar.';
}
?>