<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');
require_once 'ia-marketing-results.php';
require_once 'media/videos-ia.php';

$client_name = $client_info['name'] ?? '';
$business_name = $client_info['business_name'] ?? '';
$phone = $client_info['phone'] ?? '';
$whatsapp = $client_info['whatsapp'] ?? '';
$email = $client_info['email'] ?? '';
$website = $client_info['website'] ?? '';
$operating_cities = $client_info['operating_cities'] ?? '';
$logo_url = $client_info['logo_url'] ?? '';
$value_proposition = $ia_results['value_proposition'] ?? '';
$current_client_profiles = $ia_results['ideal_client_profiles'] ?? [];
$social_links = $client_info['social_links'] ?? [];

if (ob_get_level() > 0) { ob_end_clean(); }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Asistente De Seguimiento Para Prospectos Con <?php echo htmlspecialchars($branding['iamarketing_name']); ?> Powered_by <?php echo htmlspecialchars($branding['powered_by']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://unpkg.com/imask"></script>
    
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
    <script src="files/header-manager.js"></script>

    <style>
        .step-header h2 {
            flex-direction: column;
            align-items: flex-start;
            text-align: left;
        }
        .step-header .step-number {
            font-size: 1.25rem;
            font-weight: 900;
            margin-right: 0;
            margin-bottom: 0.25rem;
            display: flex;
            align-items: center;
            color: var(--color-secondary);
            flex-shrink: 0;
        }
        .step-header .step-number i {
            margin-right: 0.5rem;
            font-size: 1.5rem;
        }
        .step-header .step-title {
            font-size: 1.4rem;
            font-weight: 900;
            color: #1e293b;
            line-height: 1.2;
            text-transform: uppercase;
            text-align: left;
            width: 100%;
        }
        @media (min-width: 768px) {
            .step-header h2 {
                flex-direction: row;
                align-items: center;
                justify-content: flex-start;
                text-align: left;
            }
            .step-header .step-number {
                font-size: 1.5rem;
                margin-right: 0.5rem;
                margin-bottom: 0;
            }
            .step-header .step-number i {
                font-size: 1.8rem;
            }
            .step-header .step-title {
                font-size: 1.5rem;
                width: auto;
            }
        }
    </style>
</head>
<body data-page-title="Asistente De Seguimiento Para Prospectos"
      data-page-subtitle="Crea Mensajes Para Convertir De Clientes Potenciales En Clientes"
      data-page-icon="brain">

    <div id="toast-container" class="toast-container"></div>

    <?php include 'files/gtm-body.php'; ?>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="off-canvas-overlay"></div> 
    
    <?php include 'ia-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>
        
            <div id="content-area" class="p-4 md:p-8">
                <section id="prospect-message-generator" class="dashboard-section">
                    <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">
                        <div class="lg:col-span-3">
                            <form id="prospect-message-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                                <div>
                                    <div class="step-header">
                                        <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                            <span class="step-number"> <i data-lucide="user-check" class="mr-3 text-[var(--color-secondary)]"></i> PASO 1:
                                            </span>
                                            <span class="step-title"> Define el Contexto del Prospecto
                                            </span>
                                        </h2>
                                        <p class="step-subtitle uppercase">Ingresa información clave para personalizar tu mensaje</p>
                                    </div>
                                    <div class="border-b border-gray-200 pb-4 mb-6"></div>
                                    <div class="space-y-6">
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                            <div>
                                                <label for="user_name" class="block font-bold capitalize text-gray-700 mb-2 text-lg">Tu Nombre:</label>
                                                <input type="text" id="user_name" name="user_name" placeholder="Ej: Juan Pérez" class="w-full p-3 bg-gray-50 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" value="<?php echo htmlspecialchars($client_name); ?>">
                                            </div>
                                            <div>
                                                <label for="company_name" class="block font-bold capitalize text-gray-700 mb-2 text-lg">Nombre De Tu Negocio:</label>
                                                <input type="text" id="company_name" name="company_name" placeholder="Ej: Limpieza Brillante" class="w-full p-3 bg-gray-50 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" value="<?php echo htmlspecialchars($business_name); ?>">
                                            </div>
                                        </div>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                            <div>
                                                <label for="client_name" class="block font-bold capitalize text-gray-700 mb-2 text-lg">Nombre De Tu Prospecto:</label>
                                                <input type="text" id="client_name" name="client_name" placeholder="Ej: Ana Gómez" class="w-full p-3 bg-gray-50 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                            </div>
                                            <div>
                                                <label for="service_type" class="block font-bold capitalize text-gray-700 mb-2 text-lg">Servicio De Interés:</label>
                                                <input type="text" id="service_type" name="service_type" placeholder="Ej: Limpieza Profunda De Oficinas" class="w-full p-3 bg-gray-50 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                            </div>
                                        </div>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                            <div>
                                                <label for="contact_phone" class="block font-bold capitalize text-gray-700 mb-2 text-lg">Teléfono / WhatsApp (Opcional):</label>
                                                <input type="text" id="contact_phone" name="contact_phone" placeholder="(555) 123-4567" class="w-full p-3 bg-gray-50 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" value="<?php echo htmlspecialchars($phone); ?>">
                                            </div>
                                            <div>
                                                <label for="contact_web" class="block font-bold capitalize text-gray-700 mb-2 text-lg">Página Web / Red Social (Opcional):</label>
                                                <input type="text" id="contact_web" name="contact_web" placeholder="Ej: LimpiezaBrillante.com" class="w-full p-3 bg-gray-50 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" value="<?php echo htmlspecialchars($website); ?>">
                                            </div>
                                        </div>
                                        <div>
                                            <label for="scenario" class="block font-bold capitalize text-gray-700 mb-2 text-lg">Selecciona Un Escenario:</label>
                                            <select id="scenario" name="scenario" class="w-full p-3 bg-gray-50 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                                <option value="first_contact">Primer Mensaje</option>
                                                <option value="follow_up_1">Seguimiento Sutil (1-2 días)</option>
                                                <option value="follow_up_2">Seguimiento Recordatorio (3-5 días)</option>
                                                <option value="quote_sent">Envío De Cotización</option>
                                                <option value="follow_up_quote_1">Seguimiento Post-Cotización #1</option>
                                                <option value="follow_up_quote_2">Seguimiento Post-Cotización #2</option>
                                            </select>
                                        </div>
                                        <div>
                                            <label for="message_tone" class="block font-bold capitalize text-gray-700 mb-2 text-lg">Selecciona El Tono:</label>
                                            <select id="message_tone" name="message_tone" class="w-full p-3 bg-gray-50 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                                <option value="profesional_directo">Profesional y Directo</option>
                                                <option value="amigable_relajado">Amigable y Relajado</option>
                                                <option value="formal_conciso">Formal y Conciso</option>
                                            </select>
                                        </div>
                                        <div>
                                            <label for="additional_details" class="block font-bold capitalize text-gray-700 mb-2 text-lg">Detalles Adicionales (Opcional):</label>
                                            <textarea id="additional_details" name="additional_details" rows="3" placeholder="Ej: El Cliente Preguntó Por El Tiempo De Duración Del Servicio" class="w-full p-3 bg-gray-50 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]"></textarea>
                                        </div>
                                    </div>
                                </div>
                                 <input type="hidden" name="value_proposition" value="<?php echo htmlspecialchars($value_proposition); ?>">
                            </form>
                        </div>
                        
                        <div class="lg:col-span-2 space-y-8">
                            
                            <?php if (!empty($logo_url)): ?>
                                <div class="bg-white p-4 rounded-xl shadow-md">
                                    <img src="<?php echo htmlspecialchars($logo_url); ?>" 
                                         alt="Logotipo de <?php echo htmlspecialchars($business_name); ?>" 
                                         class="block mx-auto" 
                                         style="max-width: 250px;">
                                </div>
                            <?php endif; ?>
                            
                           <div class="w-full">
                                <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                                    <div class="relative w-full" style="padding-bottom: 56.25%;">
                                        <video class="absolute top-0 left-0 w-full h-full object-cover" id="videoPlayer" controls controlslist="nodownload fullscreen" preload="metadata">
                                            <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                            TU NAVEGADOR NO SOPORTA LA ETIQUETA DE VIDEO
                                        </video>
                                        <div id="playOverlay" class="absolute inset-0 flex justify-center items-center cursor-pointer group">
                                            <img src="img/VideoLeccion-IAMarketing.jpg" alt="VideoLeccion - IAMarketing" class="absolute inset-0 w-full h-full object-cover">
                                            <div class="absolute inset-0 w-full h-full bg-black/40 transition-colors group-hover:bg-black/60"></div>
                                            <i data-lucide="play" class="relative w-16 h-16 text-white opacity-80 group-hover:opacity-100 transition-opacity"></i>
                                        </div>
                                    </div>
                                    <div class="p-4 text-white/90 text-sm flex items-center justify-between">
                                        <span class="inline-flex items-center gap-2">
                                            <i data-lucide="play-circle" class="w-4 h-4"></i> Video Tutorial
                                        </span>
                                        <span class="inline-flex items-center gap-2">
                                            <i data-lucide="clock" class="w-4 h-4"></i> 2:30 min
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md">
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                        <i data-lucide="book-open" class="mr-3 text-[var(--color-highlight)]"></i>
                                        <span class="step-title">INSTRUCCIONES IMPORTANTES</span>
                                    </h2>
                                    <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>
                                <ul class="space-y-4 text-gray-700">
                                    <li class="instructions-list-item">
                                        <span class="icon-wrapper"><i data-lucide="pen-tool"></i></span>
                                        <div>
                                            <strong class="text-brand-dark uppercase">SÉ ESPECÍFICO:</strong> Cuantos más detalles des (nombre del prospecto, servicio), más persuasivo será el mensaje.
                                        </div>
                                    </li>
                                    <li class="instructions-list-item">
                                        <span class="icon-wrapper"><i data-lucide="message-square"></i></span>
                                        <div>
                                            <strong class="text-brand-dark uppercase">ELIGE EL MOMENTO:</strong> Selecciona el escenario de venta que mejor se adapte a tu situación actual.
                                        </div>
                                    </li>
                                    <li class="instructions-list-item">
                                        <span class="icon-wrapper"><i data-lucide="copy"></i></span>
                                        <div>
                                            <strong class="text-brand-dark uppercase">GENERA Y COPIA:</strong> La IA te dará mensajes profesionales listos para usar y consejos estratégicos.
                                        </div>
                                    </li>
                                    <li class="instructions-list-item">
                                        <span class="icon-wrapper"><i data-lucide="trending-up"></i></span>
                                        <div>
                                            <strong class="text-brand-dark uppercase">CIERRA MÁS VENTAS:</strong> Un buen mensaje de seguimiento es clave para convertir un prospecto en un cliente.
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="lg:col-span-5 bg-white p-6 md:p-8 rounded-xl shadow-md mt-6">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                    <span class="step-number"> <i data-lucide="zap" class="mr-3 text-[var(--color-secondary)]"></i> PASO 2:
                                    </span>
                                    <span class="step-title"> Obtén Mensajes Que Conviertan
                                    </span>
                                </h2>
                                <p class="step-subtitle uppercase">Genera mensajes persuasivos para guiar a tus prospectos a la venta</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8 items-center">

    <div class="flex flex-col justify-center items-center bg-[var(--color-primary)] p-6 rounded-xl">
        <i data-lucide="brain" class="w-24 h-24 md:w-32 md:h-32 text-white animate-pulse"></i>
        <p class="mt-4 text-white font-black text-xl uppercase tracking-wide">
            IA<span class="text-[var(--color-highlight)]">Marketing</span>™
        </p>
    </div>

    <div class="md:col-span-2 text-center md:text-left">
        
        <h3 class="text-2xl font-black text-gray-800 flex items-center justify-center md:justify-start mb-2 uppercase">
            <i data-lucide="bell-electric" class="w-6 h-6 text-[var(--color-secondary)] mr-2 flex-shrink-0"></i>
            Información Importante
        </h3>
        
        <p class="text-lg text-gray-700 mb-6">
            Para convertir interesados en clientes, <b>es muy importante</b> que identifiques cuándo es el mejor momento para el seguimiento correcto. Con esos datos, nuestra <b>inteligencia artificial</b> creará tus <b>Mensajes De Seguimiento Para Tus Prospectos</b>, para que conviertas clientes potenciales en ventas con mensajes persuasivos.
        </p>
        
        <div class="flex justify-center md:justify-start">
            <button id="generateBtn" type="submit" form="prospect-message-form" class="w-full sm:w-auto bg-[var(--color-highlight)] text-[var(--color-primary)] font-black py-4 px-6 rounded-lg hover:scale-105 transition-transform text-lg flex items-center justify-center uppercase">
                
                <i data-lucide="arrow-big-right-dash" class="w-6 h-6"></i>
                
                <span id="btn-text">GENERAR MENSAJES CON IA</span>
                
                <div id="loader-container" class="hidden ml-3"></div>
            </button>
        </div>
    </div>
    
</div>
                            
                        </div>
                        <div id="result-container" class="lg:col-span-5 mt-8"></div>
                    </div>
                </section>
            </div>
        </main>
    </div>

<script type="module">
// --- CARGA DOMCONTENT ---
document.addEventListener('DOMContentLoaded', function() {
    lucide.createIcons();
    
    // MENU MOBILE
    const mobileMenuButton = document.getElementById('mobile-menu-button');
    const sidebar = document.getElementById('sidebar');
    const sidebarOverlay = document.getElementById('sidebar-overlay');

    mobileMenuButton.addEventListener('click', () => {
        sidebar.classList.toggle('-translate-x-full');
        sidebarOverlay.classList.toggle('hidden');
    });

    sidebarOverlay.addEventListener('click', () => {
        sidebar.classList.add('-translate-x-full');
        sidebarOverlay.classList.add('hidden');
    });

    // --- NOTIFICACIONES TOAST 
    const urlParams = new URLSearchParams(window.location.search);
    const notificationType = urlParams.get('notification_type');
    const notificationMessage = urlParams.get('notification_message');

    if (notificationType && notificationMessage) {
        if (typeof showToast === 'function') {
            showToast(notificationMessage, notificationType);
        } else {
            console.error("showToast function is not defined. Toast notification might not display.");
        }
    }
    
    // VIDEO PLAYER
    const playOverlay = document.getElementById('playOverlay');
    const videoPlayer = document.getElementById('videoPlayer');
    
    playOverlay.addEventListener('click', () => {
        playOverlay.style.display = 'none';
        videoPlayer.play();
    });
    
     // MASCARA DEL TELEFONO
    const phoneInput = document.getElementById('contact_phone');
    if (phoneInput) {
        IMask(phoneInput, { mask: '(000) 000-0000' });
    }

    const form = document.getElementById('prospect-message-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loaderContainer = document.getElementById('loader-container');

    function setProcessingState(isProcessing) {
        if (isProcessing) {
            loaderContainer.innerHTML = '<div class="w-6 h-6 border-4 border-t-transparent border-[var(--color-primary)] rounded-full animate-spin"></div>';
            loaderContainer.classList.remove('hidden');
            generateBtn.disabled = true;
            generateBtn.classList.add('opacity-50', 'cursor-not-allowed');
            resultContainer.innerHTML = '';
            resultContainer.style.opacity = '0';
            const messages = ["Contactando con OrozCO IA...", "Analizando tu contexto...", "Redactando los mensajes...", "Afinando el mensaje...", "¡Casi listo para enviar!"];
            let messageIndex = 0;
            btnText.textContent = messages[messageIndex];
            window.loadingInterval = setInterval(() => {
                messageIndex = (messageIndex + 1) % messages.length;
                btnText.textContent = messages[messageIndex];
            }, 2500);
        } else {
            if (window.loadingInterval) clearInterval(window.loadingInterval);
            loaderContainer.classList.add('hidden');
            generateBtn.disabled = false;
            generateBtn.classList.remove('opacity-50', 'cursor-not-allowed');
            btnText.textContent = 'GENERAR OTROS MENSAJES';
        }
    }

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        
        const requiredFields = ['user_name', 'company_name', 'client_name', 'service_type', 'scenario', 'message_tone'];
        let allFieldsValid = true;
        requiredFields.forEach(id => {
            const input = document.getElementById(id);
            if (!input.value.trim()) {
                allFieldsValid = false;
                input.classList.add('border-[var(--color-secondary)]');
            } else {
                input.classList.remove('border-[var(--color-secondary)]');
            }
        });

        if (!allFieldsValid) {
            showToast('Por favor, completa todos los campos obligatorios.', 'warning');
            return;
        }

        setProcessingState(true);

        const formData = {
            user_name: document.getElementById('user_name').value,
            company_name: document.getElementById('company_name').value,
            client_name: document.getElementById('client_name').value,
            service_type: document.getElementById('service_type').value,
            contact_phone: document.getElementById('contact_phone').value,
            contact_web: document.getElementById('contact_web').value,
            scenario: document.getElementById('scenario').value,
            message_tone: document.getElementById('message_tone').value,
            additional_details: document.getElementById('additional_details').value
        };

        try {
            const response = await fetch('api/api-asistente-de-seguimiento-prospectos.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || `Error del servidor: ${response.status}.`);
            }
            const data = await response.json();
            if(data.error) throw new Error(data.error);

            displayResult(data.suggestions);
            showToast('¡Mensajes generados con éxito!', 'success');

        } catch (error) {
            console.error("Error:", error);
            let errorMessage = 'Hubo un problema al generar tu mensaje. Por favor, intenta de nuevo.';
            try {
                const errorDetails = JSON.parse(error.message.substring(error.message.indexOf('{')));
                if (errorDetails.error) {
                    errorMessage = errorDetails.error;
                }
            } catch (e) { /* ignore */ }
            
            resultContainer.innerHTML = `<div class="bg-[var(--color-secondary)] text-center p-4 text-white rounded-lg border border-[var(--color-secondary)]"><p><strong>Error:</strong> ${errorMessage}</p></div>`;
            resultContainer.style.opacity = '1';
            showToast(errorMessage, 'error');
        } finally {
            setProcessingState(false);
        }
    });

    function displayResult(suggestions) {
        resultContainer.innerHTML = '';
        suggestions.forEach((data, index) => {
            const messageCard = document.createElement('div');
            messageCard.className = 'ai-response p-6 md:p-8 rounded-xl shadow-md space-y-6 animate-slideInUp';
            messageCard.style.animationDelay = `${index * 150}ms`;
            
            const spanish_message = data.spanish_message || "No disponible.";
            const english_message = data.english_message || "Not available.";
            const tip = data.tip || "No hay consejos adicionales.";

            messageCard.innerHTML = `
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <h3 class="text-xl font-bold text-gray-800 mb-3 flex items-center"><i data-lucide="message-square" class="mr-2 text-[var(--color-primary)]"></i>Mensaje Sugerido #${index + 1} (Español)</h3>
                        <div class="message-box bg-gray-50 p-4 rounded-lg border border-gray-200 shadow-sm whitespace-pre-wrap">${spanish_message.replace(/\n/g, '<br>')}</div>
                        <div class="copy-btn-wrapper mt-3">
                            <button class="btn-copy" data-copytarget-text="${encodeURIComponent(spanish_message)}">
                                <i data-lucide="copy"></i><span class="copy-text">Copiar Mensaje</span>
                            </button>
                        </div>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold text-gray-800 mb-3 flex items-center"><i data-lucide="message-square" class="mr-2 text-[var(--color-primary)]"></i>Suggested Message #${index + 1} (English)</h3>
                        <div class="message-box bg-gray-50 p-4 rounded-lg border border-gray-200 shadow-sm whitespace-pre-wrap">${english_message.replace(/\n/g, '<br>')}</div>
                        <div class="copy-btn-wrapper mt-3">
                            <button class="btn-copy" data-copytarget-text="${encodeURIComponent(english_message)}">
                                <i data-lucide="copy"></i><span class="copy-text">Copy Message</span>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="pt-4 border-t border-gray-200">
                    <h3 class="text-xl font-bold text-gray-800 mb-3 flex items-center"><i data-lucide="lightbulb" class="mr-2 text-[var(--color-highlight)]"></i>Consejo Estratégico</h3>
                    <div class="tip-box bg-yellow-50 p-4 rounded-lg border-l-4 border-yellow-400 flex items-start">
                        <i data-lucide="info" class="text-yellow-500 mr-3 mt-1 flex-shrink-0"></i>
                        <div class="text-gray-700">${tip}</div>
                    </div>
                </div>
            `;
            resultContainer.appendChild(messageCard);
        });
        
        lucide.createIcons();
        setTimeout(() => { 
            resultContainer.style.opacity = '1'; 
            resultContainer.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }, 100);

        resultContainer.querySelectorAll('.btn-copy').forEach(button => {
            button.addEventListener('click', function() {
                const textToCopy = decodeURIComponent(this.dataset.copytargetText);
                navigator.clipboard.writeText(textToCopy).then(() => {
                    const buttonContent = this;
                    const originalHTML = buttonContent.innerHTML;

                    buttonContent.innerHTML = '<i data-lucide="check"></i><span class="copy-text">Copiado!</span>';
                    lucide.createIcons();
                    buttonContent.classList.add('copied');
                    showToast('Mensaje copiado al portapapeles.', 'success');
                    
                    setTimeout(() => {
                        buttonContent.innerHTML = originalHTML;
                        buttonContent.classList.remove('copied');
                        lucide.createIcons({ nodes: [buttonContent] });
                    }, 2000);
                }).catch(err => {
                    console.error('Error al copiar:', err);
                    showToast('No se pudo copiar el texto.', 'error');
                });
            });
        });
    }
});
</script>
<script src="files/toast.js"></script>
</body>
</html>