document.addEventListener('DOMContentLoaded', () => {

    if (window.lucide?.createIcons) {
        lucide.createIcons();
    }

    const body = document.body;

    const togglePanel = (panel, overlay, isOpen, animationClass) => {
        if (!panel || !overlay) return;

        if (isOpen) {
            panel.classList.remove(animationClass); 
            overlay.classList.remove("pointer-events-none", "opacity-0");
            body.classList.add("overflow-hidden");
        } else {
            panel.classList.add(animationClass); 
            overlay.classList.add("pointer-events-none", "opacity-0");
            body.classList.remove("overflow-hidden");
        }
    };

    // A. Sidebar
    const sidebar = document.getElementById("sidebar");
    const navOverlay = document.getElementById("nav-overlay");
    const openSidebarBtn = document.getElementById("open-sidebar");
    const closeSidebarBtn = document.getElementById("close-sidebar");

    if (openSidebarBtn) openSidebarBtn.addEventListener("click", () => togglePanel(sidebar, navOverlay, true, "-translate-x-full"));
    if (closeSidebarBtn) closeSidebarBtn.addEventListener("click", () => togglePanel(sidebar, navOverlay, false, "-translate-x-full"));
    if (navOverlay) navOverlay.addEventListener("click", () => togglePanel(sidebar, navOverlay, false, "-translate-x-full"));

    // B. Panel de Ayuda
    const helpPanel = document.getElementById("help-panel");
    const helpOverlay = document.getElementById("help-overlay");
    const helpTriggers = document.querySelectorAll("#open-help, #open-help-top, #open-help-mobile");
    const helpClosers = document.querySelectorAll("[data-close-help]");

    helpTriggers.forEach(btn => btn.addEventListener("click", () => togglePanel(helpPanel, helpOverlay, true, "translate-x-full")));
    helpClosers.forEach(btn => btn.addEventListener("click", () => togglePanel(helpPanel, helpOverlay, false, "translate-x-full")));
    if (helpOverlay) helpOverlay.addEventListener("click", () => togglePanel(helpPanel, helpOverlay, false, "translate-x-full"));

    document.addEventListener("keydown", (e) => {
        if (e.key === "Escape") {
            togglePanel(sidebar, navOverlay, false, "-translate-x-full");
            togglePanel(helpPanel, helpOverlay, false, "translate-x-full");
        }
    });

    const switcherBtn = document.getElementById('platform-switcher-button');
    const switcherDropdown = document.getElementById('platform-switcher-dropdown');
    const mainNav = document.getElementById('main-nav');

    if (switcherBtn && switcherDropdown && mainNav) {
        switcherBtn.addEventListener('click', (e) => {
            e.stopPropagation();
            
            const btnRect = switcherBtn.getBoundingClientRect();
            const navRect = mainNav.getBoundingClientRect();
            const spaceBelow = navRect.bottom - btnRect.bottom;
            const dropdownHeight = switcherDropdown.offsetHeight || 180;

            switcherDropdown.classList.remove('opens-up', 'opens-down');
            
            if (spaceBelow < dropdownHeight && btnRect.top > dropdownHeight) {
                switcherDropdown.classList.add('opens-up');
            } else {
                switcherDropdown.classList.add('opens-down');
            }
            
            switcherDropdown.classList.toggle('hidden');
        });

        document.addEventListener('click', (e) => {
            if (!switcherBtn.contains(e.target) && !switcherDropdown.contains(e.target)) {
                switcherDropdown.classList.add('hidden');
            }
        });
    }

    document.querySelectorAll('.accordion-toggle').forEach(button => {
        const content = button.nextElementSibling;
        const icon = button.querySelector('.accordion-icon');
        
        if (content && content.hasAttribute('data-active')) {
            content.style.maxHeight = content.scrollHeight + "px";
            if (icon) icon.style.transform = 'rotate(180deg)';
        }

        button.addEventListener('click', () => {
            if (!content) return;
            
            const isOpen = content.style.maxHeight;
            content.style.maxHeight = isOpen ? null : content.scrollHeight + "px";
            if (icon) icon.style.transform = isOpen ? 'rotate(0deg)' : 'rotate(180deg)';
        });
    });
});