<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Error Página No Encontrada <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css">
    
    <style>
        .content-background {
            background-image: url('img/BG-FlowCRM.webp');
            background-size: cover;
            background-position: center;
            position: relative;
        }
        .overlay {
            background: linear-gradient(135deg, rgba(7, 22, 45, 0.85) 0%, rgba(158, 20, 40, 0.65) 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
        }
      
        .content-card {
            animation: fadeInScaleUp 0.6s ease-out forwards;
        }
        @keyframes fadeInScaleUp {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
    </style>
</head>
<body class="flex">

    <div class="flex-1 flex flex-col">
        <main class="flex-1 flex flex-col content-background">
            <div class="overlay p-4 flex-1">
                
                <div class="max-w-2xl w-full text-center content-card">
                    <div class="flex justify-center mb-6">
                        <i data-lucide="alert-triangle" class="h-28 w-28 text-yellow-400 drop-shadow-lg"></i>
                    </div>
                    <h1 class="text-6xl font-extrabold text-white leading-tight drop-shadow-md">
                        Hubo un Error
                    </h1>
                    <p class="mt-4 text-xl text-gray-200 max-w-lg mx-auto drop-shadow-md">
                        No pudimos procesar tu solicitud en este momento. Por favor, vuelve a intentarlo.
                    </p>
                    
                    <div class="mt-10 grid grid-cols-1 sm:grid-cols-2 gap-4 max-w-lg mx-auto">
                        <a href="javascript:history.back()" class="btn-primary w-full flex items-center justify-center p-4 rounded-lg uppercase font-bold text-lg shadow-lg">
                            <i data-lucide="rotate-cw" class="w-6 h-6 mr-3"></i>
                            <span>Reintentar</span>
                        </a>
                        <a href="mailto:soporte@tunegociocrm.com" class="btn-secondary w-full flex items-center justify-center p-4 rounded-lg uppercase font-bold text-lg shadow-lg">
                            <i data-lucide="shield-question" class="w-6 h-6 mr-3"></i>
                            <span>Contactar Soporte</span>
                        </a>
                    </div>
                </div>

            </div>
        </main>
    </div>

    <script>
        lucide.createIcons();
    </script>
    <script src="files/toast.js"></script>
</body>
</html>