<?php
ob_start(); 

require_once __DIR__ . '/../core/api.php';
global $pdo;

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/php_errors.log');
error_reporting(E_ALL);

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'ERROR POR DEFECTO'];

try {

    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    if (!$data) {
        throw new Exception('ERROR EN LOS DATOS RECIBIDOS');
    }

    // Se asume user_id = 1 por el contexto de la aplicacin, pero debera provenir de la sesin.
    $user_id = $data['user_id'] ?? 1;

    $access_code = random_int(10000, 99999);

    $pdo->beginTransaction();

    // Se incluye user_id en el INSERT para consistencia.
    $stmt = $pdo->prepare("INSERT INTO clients (user_id, first_name, last_name, email, phone, mobile, street_address, city, state_province, zip_code, is_recurring, access_code) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        $user_id,
        $data['first_name'] ?? null,
        $data['last_name'] ?? null,
        $data['email'] ?? null,
        $data['phone'] ?? null,
        $data['mobile'] ?? null,
        $data['street_address'] ?? null,
        $data['city'] ?? null,
        $data['state_province'] ?? null,
        $data['zip_code'] ?? null,
        ($data['is_recurring'] ?? 0) ? 1 : 0,
        $access_code
    ]);
    $client_id = $pdo->lastInsertId();

    if (!empty($data['assigned_service_ids'])) {
        $service_stmt = $pdo->prepare("INSERT INTO client_services (client_id, service_id) VALUES (?, ?)");
        foreach ($data['assigned_service_ids'] as $service_id) {
            if (filter_var($service_id, FILTER_VALIDATE_INT)) {
                 $service_stmt->execute([$client_id, $service_id]);
            }
        }
    }
    
    if (!empty($data['prospect_id'])) {
        $delete_lead_stmt = $pdo->prepare("DELETE FROM leads WHERE id = ?");
        $delete_lead_stmt->execute([$data['prospect_id']]);
    }

    $pdo->commit();
    $response = ['success' => true, 'message' => 'CLIENTE CREADO'];

} catch (PDOException $e) {
    if (isset($pdo) && $pdo->inTransaction()) { $pdo->rollBack(); }
    error_log("Error en clients-create.php: " . $e->getMessage());
    if ($e->errorInfo[1] == 1062) {
        $response['message'] = 'ERROR: YA EXISTE UN CLIENTE CON ESE EMAIL O TEL07FONO';
    } else {
        $response['message'] = 'ERROR DE BASE DE DATOS';
    }
} catch (Exception $e) {
     if (isset($pdo) && $pdo->inTransaction()) { $pdo->rollBack(); }
     error_log("Error en clients-create.php: " . $e->getMessage());
     $response['message'] = $e->getMessage();
}

ob_end_clean();
echo json_encode($response);
exit;