<?php
ob_start();
header('Content-Type: application/json');

require_once __DIR__ . '/../core/api.php';
global $pdo;

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') throw new Exception('Método incorrecto');

    $id = 1; 
    $full_name = $_POST['full_name'] ?? '';
    $company_name = $_POST['company_name'] ?? '';
    $site_email = $_POST['site_email'] ?? '';
    $website_url = $_POST['website_url'] ?? '';
    $phone_primary = $_POST['phone_primary'] ?? '';
    $phone_secondary = $_POST['phone_secondary'] ?? '';
    $license_number = $_POST['license_number'] ?? '';
    $whatsapp = $_POST['whatsapp'] ?? '';

    $check = $pdo->prepare("SELECT id FROM business_info WHERE id = ?");
    $check->execute([$id]);
    
    if ($check->fetch()) {
        $sql = "UPDATE business_info SET full_name=?, company_name=?, site_email=?, website_url=?, phone_primary=?, phone_secondary=?, license_number=?, whatsapp=? WHERE id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$full_name, $company_name, $site_email, $website_url, $phone_primary, $phone_secondary, $license_number, $whatsapp, $id]);
    } else {
        $sql = "INSERT INTO business_info (id, full_name, company_name, site_email, website_url, phone_primary, phone_secondary, license_number, whatsapp) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$id, $full_name, $company_name, $site_email, $website_url, $phone_primary, $phone_secondary, $license_number, $whatsapp]);
    }

    echo json_encode(['success' => true, 'message' => 'Información actualizada']);

} catch (Exception $e) {
    error_log("Error en business-info-update.php: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
ob_end_clean();
?>