<?php
// 1. Obtener País desde BD
if (isset($pdo) && empty($branding['country_code'])) {
    $stmtGeo = $pdo->prepare("SELECT timezone, country_code, currency_code FROM business_info LIMIT 1");
    $stmtGeo->execute();
    $geoData = $stmtGeo->fetch(PDO::FETCH_ASSOC);
} else {
    global $branding;
    $geoData = [
        'timezone' => $branding['timezone'],
        'country_code' => $branding['country_code'],
        'currency_code' => $branding['currency_code']
    ];
}

// 2. Configurar Zona Horaria
$server_timezone = $geoData['timezone'];
date_default_timezone_set($server_timezone);
if(isset($pdo)) {
    $pdo->exec("SET time_zone = '" . date('P') . "'");
}

// 3. Cargar Datos del País
$all_countries = require __DIR__ . '/country_data.php';
$my_country_code = strtoupper($geoData['country_code']);

$current_locale = $all_countries[$my_country_code] ?? $all_countries['US'];

// 4. Definir CONSTANTES PURAS (Sin lógica, solo datos)
define('CRM_COUNTRY_CODE', $my_country_code);
define('CRM_PHONE_PREFIX', $current_locale['phone_prefix']);
define('CRM_CURRENCY_SYMBOL', $current_locale['currency_symbol']);
define('CRM_CURRENCY_CODE', $geoData['currency_code']);
define('CRM_CURRENCY_POS', $current_locale['currency_pos']); // 'before' o 'after'
define('CRM_DATE_FORMAT', $current_locale['date_format']);
define('CRM_TIME_FORMAT', $current_locale['time_format']);
define('CRM_DEC_POINT', $current_locale['dec_point']);
define('CRM_THOUSANDS_SEP', $current_locale['thousands_sep']);
define('CRM_LOCALE_ID', $current_locale['locale']);

// 5. Configurar Localización PHP
$loc = CRM_LOCALE_ID;
setlocale(LC_ALL, $loc, $loc.'.utf8', $loc.'.UTF-8');
?>