<?php
// /IAMarketing/api/api-swot-analysis.php
ob_start();
require_once __DIR__ . '/../config.php';

header('Content-Type: application/json');

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(['error' => 'Método no permitido. Solo se aceptan solicitudes POST.']);
        exit;
    }

    if (!defined('GEMINI_API_KEY') || empty(GEMINI_API_KEY)) {
        http_response_code(500);
        echo json_encode(['error' => 'La clave de API de Gemini no está configurada en el servidor.']);
        exit;
    }

    $apiKey = GEMINI_API_KEY;
    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        echo json_encode(['error' => 'Formato de datos JSON inválido.']);
        exit;
    }

    $business_context = "
        - Nombre del Dueño: {$data['person_name']}
        - Nombre del Negocio: {$data['business_name']}
        - Ubicación (Ciudad/Estado): {$data['location']}
        - Tipo de Negocio/Industria: {$data['business_type']}
        - Cliente Ideal: {$data['target_client']}
        - Propuesta De Valor: {$data['value_proposition']}
    ";

    $strengths = implode("\n- ", $data['strengths_questions']) . "\nInformación adicional: " . $data['strengths_extra'];
    $weaknesses = implode("\n- ", $data['weaknesses_questions']) . "\nInformación adicional: " . $data['weaknesses_extra'];
    $opportunities = implode("\n- ", $data['opportunities_questions']) . "\nInformación adicional: " . $data['opportunities_extra'];
    $threats = implode("\n- ", $data['threats_questions']) . "\nInformación adicional: " . $data['threats_extra'];

    $prompt = "
    Actúa como un consultor de negocios senior y estratega para PYMES. Tu misión es analizar la información proporcionada por un dueño de negocio y convertirla en un plan de acción claro, conciso y potente.

    ---
    **INFORMACIÓN RECIBIDA DEL NEGOCIO:**

    **1. Contexto del Negocio:**
    {$business_context}

    **2. Fortalezas (interno, positivo):**
    - {$strengths}

    **3. Debilidades (interno, negativo):**
    - {$weaknesses}

    **4. Oportunidades (externo, positivo):**
    - {$opportunities}

    **5. Amenazas (externo, negativo):**
    - {$threats}

    **6. Objetivo Principal del Negocio:**
    {$data['objective']}
    ---

    **TU MISIÓN Y ESTRUCTURA DE RESPUESTA:**

    Basado en TODA la información anterior, genera un **Plan de Acción Estratégico**. La respuesta debe ser motivadora, clara y fácil de seguir. Utiliza el delimitador '---SECCION---' para separar las partes del plan.

    **Formato de Respuesta Obligatorio:**

    **1. TÍTULO Y RESUMEN:**
       - Comienza con un Título Principal: `**Análisis Estratégico Y Plan De Acción Para {$data['business_name']}**`
       - Sigue con un párrafo introductorio que se dirija al dueño por su nombre ({$data['person_name']}) y resuma tu comprensión del negocio y su objetivo principal.

    ---SECCION---

    **2. PLAN DE ACCIÓN ESTRATÉGICO:**
       - Crea un título para esta sección: `**PLAN DE ACCIÓN ESTRATÉGICO**`
       - Genera 4 sub-secciones con estrategias claras y accionables, basadas en el cruce del análisis FODA:

         **A. Estrategias Ofensivas (Fortalezas + Oportunidades):**
         **Acción 1:** [Recomendación concreta]
         **Acción 2:** [Recomendación concreta]

         **B. Estrategias de Reorientación (Debilidades + Oportunidades):**
         **Acción 1:** [Recomendación concreta]
         **Acción 2:** [Recomendación concreta]

         **C. Estrategias Defensivas (Fortalezas + Amenazas):**
         **Acción 1:** [Recomendación concreta]
         **Acción 2:** [Recomendación concreta]

         **D. Estrategias de Supervivencia (Debilidades + Amenazas):**
         **Acción 1:** [Recomendación concreta]
         **Acción 2:** [Recomendación concreta]

    **Instrucciones Finales:**
    - La respuesta debe ser únicamente texto plano.
    - Usa **Acción 1:**, **Acción 2:**, etc., para cada punto del plan.
    - NO INCLUYAS la sección 'PRÓXIMOS PASOS RECOMENDADOS'. Omite esa parte por completo.
    ";

    $apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/' . GEMINI_MODEL . ':generateContent?key=' . $apiKey;
    $payload = [ 'contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => [ 'temperature' => 0.8, 'top_k' => 40, 'top_p' => 0.95, ]];

    $ch = curl_init($apiUrl);
    curl_setopt_array($ch, [ CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => true, CURLOPT_POSTFIELDS => json_encode($payload), CURLOPT_HTTPHEADER => ['Content-Type: application/json'], CURLOPT_TIMEOUT => 120 ]);
    
    $response_ai = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch);
    curl_close($ch);

    // --- SECCIÓN DE DEBUG MODIFICADA ---
    if ($response_ai === false || $http_code !== 200) {
        http_response_code(502);
        
        // Devolvemos el error real de cURL y de Google para depurar
        echo json_encode([
            'error' => 'No se pudo obtener una respuesta válida del servicio de IA.',
            'curl_error' => $curl_error, // Error de cURL (ej: "SSL certificate problem", "Connection timed out")
            'api_http_code' => $http_code, // Código de Google (ej: 403, 429, 400)
            'api_response_body' => json_decode($response_ai) // El JSON de error que envió Google
        ]);
        exit;
    }
    // --- FIN DE LA MODIFICACIÓN ---

    $result_array = json_decode($response_ai, true);
    
    if (!isset($result_array['candidates'][0]['content']['parts'][0]['text'])) {
        http_response_code(500);
        echo json_encode(['error' => 'La respuesta de la IA llegó con un formato inesperado.']);
        exit;
    }
    
    $response_text = $result_array['candidates'][0]['content']['parts'][0]['text'];

    if (empty(trim($response_text))) {
        http_response_code(500);
        echo json_encode(['error' => 'La respuesta de la IA llegó vacía.']);
        exit;
    }

    ob_end_clean();
    echo json_encode(['generated_content' => trim($response_text)]);
    exit;

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error interno del servidor: ' . $e->getMessage()]);
    exit;
} finally {
    while (ob_get_level() > 0) {
        ob_end_flush();
    }
}
?>