<?php
// /IAMarketing/api/api-project-proposals.php
ob_start();
require_once __DIR__ . '/../files/guardiankey.php';
require_once __DIR__ . '/../config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido.']);
    exit;
}

if (!defined('GEMINI_API_KEY') || empty(GEMINI_API_KEY) || !defined('GEMINI_MODEL') || empty(GEMINI_MODEL)) {
    http_response_code(500);
    echo json_encode(['error' => 'La clave de API de Gemini o el modelo no están configurados.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['error' => 'JSON mal formado.']);
    exit;
}

// Prompt Final - Instruye a la IA a generar HTML directamente para los títulos.
$prompt = "
Actúa como un consultor de negocios y redactor de propuestas de élite. Tu tarea es crear una propuesta comercial profesional, persuasiva y limpia.

**REGLAS CRÍTICAS E INQUEBRABLES:**
1.  **FORMATO DE TÍTULOS:** Para todos los títulos de sección, DEBES usar este marcador especial: `## Título De La Sección ##`. 
    * Ejemplo: `## Introducción y Entendimiento del Proyecto ##`
    * **NO USES HTML, NO USES <h3>, NO USES ASTERISCOS.** Solo el formato `## Título ##`.
2.  **LISTAS:** Para listas de entregables, usa guiones simples.
    * Ejemplo:
    * - Entregable 1
    * - Entregable 2
3.  **CERO PLACEHOLDERS:** NUNCA uses placeholders como '[Nombre del Cliente]'. Inserta los valores del contexto directamente.
4.  **FIRMA PROFESIONAL:** La propuesta DEBE terminar con un cierre cordial y una firma que incluya el nombre y la empresa proporcionados.

**Contexto (Datos para la propuesta):**
- Tu Nombre: {$data['your_name']}
- Tu Empresa: {$data['your_company']}
// ... (El resto del contexto no cambia) ...

**Tu Tarea Detallada:**
Redacta el texto completo de la propuesta en español y su traducción profesional al inglés. Sigue esta estructura y directrices de contenido, usando el marcador `## Título ##` para cada título:

`## Introducción y Entendimiento del Proyecto ##`
- Saluda al cliente por su nombre. Escribe de parte de tu empresa. Confirma que has entendido su necesidad y presenta esta propuesta para abordarla, mencionando el proyecto de forma natural.

`## Alcance del Proyecto y Entregables ##`
- Presenta la lista de entregables clave (usando guiones) de forma clara.

`## Plazos e Inversión ##`
- Especifica el plazo, la inversión total y la validez de la propuesta.

`## Próximos Pasos ##`
- Explica qué necesita hacer el cliente para comenzar el proyecto.

`## Cierre y Firma ##`
- Termina con una frase cordial como \"Quedo a su disposición para cualquier consulta.\".
- Añade un cierre formal como \"Atentamente,\".
- En la siguiente línea, tu nombre: {$data['your_name']}.
- En la línea final, el nombre de tu empresa: {$data['your_company']}.

**Formato de Salida Obligatorio:**
Un único objeto JSON con dos claves: `proposal_spanish` y `proposal_english`. El valor de cada clave debe ser el texto completo con los marcadores `## Título ##` (NO HTML).
";

$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/' . GEMINI_MODEL . ':generateContent?key=' . GEMINI_API_KEY;

$payload = [
    'contents' => [['parts' => [['text' => $prompt]]]],
    'generationConfig' => [
        'response_mime_type' => 'application/json',
        'response_schema' => [
            'type' => 'OBJECT',
            'properties' => [
                'proposal_spanish' => ['type' => 'STRING'],
                'proposal_english' => ['type' => 'STRING']
            ],
            'required' => ['proposal_spanish', 'proposal_english']
        ]
    ]
];

$ch = curl_init($apiUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
    CURLOPT_TIMEOUT => 90
]);

$response_ai = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

if ($response_ai === false || $http_code !== 200) {
    http_response_code(502);
    echo json_encode(['error' => 'No se pudo obtener una respuesta válida del servicio de IA.', 'details' => $curl_error, 'http_code' => $http_code]);
    exit;
}

$result_array = json_decode($response_ai, true);
$raw_response_text = $result_array['candidates'][0]['content']['parts'][0]['text'] ?? '';
$response_data = json_decode($raw_response_text, true);

if ($response_data === null || !isset($response_data['proposal_spanish']) || !isset($response_data['proposal_english'])) {
    http_response_code(500);
    echo json_encode(['error' => 'La IA no devolvió una propuesta con el formato esperado.']);
    exit;
}

ob_end_clean();
echo json_encode($response_data);
exit;
?>