<?php
// /IAMarketing/api-db/project-proposals-update.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$business_id = 1; // Para seguridad, nos aseguramos que solo edite las suyas

if (isset($data['id']) && isset($data['proposal_name']) && isset($data['proposal_spanish']) && isset($data['proposal_english'])) {
    
    $id = $data['id'];
    $proposal_name = trim($data['proposal_name']);
    $proposal_spanish = trim($data['proposal_spanish']);
    $proposal_english = trim($data['proposal_english']);

    if (empty($proposal_name)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'El nombre de la propuesta no puede estar vacío.']);
        exit;
    }

    try {
        // Actualizar el registro por ID, asegurándose que pertenezca al business_id
        $sql = "UPDATE ia_project_proposals_results 
                SET proposal_name = ?, proposal_spanish = ?, proposal_english = ? 
                WHERE id = ? AND business_info_id = ?";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$proposal_name, $proposal_spanish, $proposal_english, $id, $business_id]);
        
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Propuesta actualizada exitosamente.']);
        } else {
            // Esto puede pasar si no se encontró el ID o si los datos eran idénticos
            echo json_encode(['success' => false, 'message' => 'No se pudo actualizar la propuesta (puede que no exista o no se detectaron cambios).']);
        }
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error de base de datos al actualizar la propuesta: ' . $e->getMessage()]);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Datos incompletos. Se requiere ID y todos los campos de la propuesta.']);
}
?>