<?php
// /IAMarketing/api-db/ia-post-title-generator-fetch.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

try {
    $business_id = 1; // Assuming business_info_id = 1

    // 1. Obtener todos los títulos guardados para este business_info_id
    // Los campos de título serán NULL si no se usaron al guardar el registro.
    $sql = "SELECT 
                id, 
                titulo_problema_es, titulo_problema_en,
                titulo_solucion_es, titulo_solucion_en,
                titulo_servicio_es, titulo_servicio_en,
                service_input,
                created_at 
            FROM ia_post_title_generator_results 
            WHERE business_info_id = ? 
            ORDER BY created_at DESC";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id]);
    
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 2. Procesar los resultados para un formato más usable en el frontend
    $processed_titles = [];
    foreach ($results as $row) {
        $title_data = [
            'id' => $row['id'],
            'service_input' => $row['service_input'],
            'created_at' => $row['created_at']
        ];
        
        // Determinar qué tipo de título fue guardado en este registro
        if (!empty($row['titulo_problema_es'])) {
            $title_data['type'] = 'Problema';
            $title_data['es'] = $row['titulo_problema_es'];
            $title_data['en'] = $row['titulo_problema_en'];
        } elseif (!empty($row['titulo_solucion_es'])) {
            $title_data['type'] = 'Solución';
            $title_data['es'] = $row['titulo_solucion_es'];
            $title_data['en'] = $row['titulo_solucion_en'];
        } elseif (!empty($row['titulo_servicio_es'])) {
            $title_data['type'] = 'Servicio/Oferta';
            $title_data['es'] = $row['titulo_servicio_es'];
            $title_data['en'] = $row['titulo_servicio_en'];
        } else {
            // Caso donde el registro está vacío (debería ser raro, pero es un safety net)
            $title_data['type'] = 'Vacío/Inválido';
            $title_data['es'] = 'Registro sin título principal.';
            $title_data['en'] = 'Record without main title.';
        }
        
        $processed_titles[] = $title_data;
    }
    
    echo json_encode(['success' => true, 'titles' => $processed_titles]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error while fetching titles: ' . $e->getMessage()]);
}
?>