<?php
// /IAMarketing/api-db/ia-post-title-generator-create.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

// Validación de la estructura de datos para un TÍTULO INDIVIDUAL
if (!isset($data['title_type']) || !isset($data['title_es']) || !isset($data['inputs']['service'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Required title data (type, content, or inputs) not received.']);
    exit;
}

try {
    $business_id = 1; // Assuming business_info_id = 1
    
    // 1. Aplicar el límite de 5 títulos individuales
    $limit_sql = "SELECT COUNT(id) AS count FROM ia_post_title_generator_results WHERE business_info_id = ?";
    $limit_stmt = $pdo->prepare($limit_sql);
    $limit_stmt->execute([$business_id]);
    $current_count = $limit_stmt->fetch(PDO::FETCH_ASSOC)['count'];
    
    if ($current_count >= 5) {
        http_response_code(409); // Conflict, límite alcanzado
        echo json_encode(['success' => false, 'message' => 'Límite de 5 títulos individuales alcanzado. Elimina uno para guardar el nuevo.']);
        exit;
    }

    // 2. Inicializar todas las variables a NULL
    $titulo_problema_es = $titulo_problema_en = NULL;
    $titulo_solucion_es = $titulo_solucion_en = NULL;
    $titulo_servicio_es = $titulo_servicio_en = NULL;

    // 3. Asignar solo el título que se va a guardar
    switch ($data['title_type']) {
        case 'problema':
            $titulo_problema_es = $data['title_es'];
            $titulo_problema_en = $data['title_en'] ?? NULL;
            break;
        case 'solucion':
            $titulo_solucion_es = $data['title_es'];
            $titulo_solucion_en = $data['title_en'] ?? NULL;
            break;
        case 'servicio':
            $titulo_servicio_es = $data['title_es'];
            $titulo_servicio_en = $data['title_en'] ?? NULL;
            break;
    }
    
    // 4. Insertar el nuevo registro en la tabla CORRECTA
    $sql = "INSERT INTO ia_post_title_generator_results (
        business_info_id, service_input, client_summary_input,
        titulo_problema_es, titulo_problema_en, titulo_solucion_es,
        titulo_solucion_en, titulo_servicio_es, titulo_servicio_en
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $pdo->prepare($sql);
    $success = $stmt->execute([
        $business_id,
        $data['inputs']['service'],
        $data['inputs']['ideal_client_summary'],
        $titulo_problema_es,
        $titulo_problema_en,
        $titulo_solucion_es,
        $titulo_solucion_en,
        $titulo_servicio_es,
        $titulo_servicio_en
    ]);

    if ($success) {
        $new_id = $pdo->lastInsertId();
        echo json_encode([
            'success' => true, 
            'message' => 'Título individual guardado con éxito.',
            'new_title_id' => $new_id
        ]);
    } else {
         http_response_code(500);
         echo json_encode(['success' => false, 'message' => 'Insert failed.']);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error while creating Title Record: ' . $e->getMessage()]);
}
?>