<?php
// /IAMarketing/api-db/ia-marketing-goal-planner-update.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$business_id = 1; // Asumiendo business_info_id = 1

// Validar campos
$required_keys = ['analisis_objetivos', 'analisis_viabilidad', 'plan_de_accion', 'metricas_clave', 'recomendaciones_optimizacion'];
foreach ($required_keys as $key) {
    if (!isset($data[$key])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => "Faltan datos del plan (clave: $key)."]);
        exit;
    }
}

try {
    $sql = "UPDATE ia_marketing_goal_planner_results SET 
                analisis_objetivos = ?, 
                analisis_viabilidad = ?, 
                plan_de_accion = ?, 
                metricas_clave = ?, 
                recomendaciones_optimizacion = ?
            WHERE business_info_id = ?"; // Lógica 1-a-1
    
    $stmt = $pdo->prepare($sql);
    
    $plan_json = json_encode($data['plan_de_accion']);
    
    $stmt->execute([
        $data['analisis_objetivos'],
        $data['analisis_viabilidad'],
        $plan_json,
        $data['metricas_clave'],
        $data['recomendaciones_optimizacion'],
        $business_id // ID del negocio
    ]);
    
    echo json_encode(['success' => true, 'message' => 'Plan de Marketing actualizado exitosamente.']);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al actualizar el Plan: ' . $e->getMessage()]);
}
?>