<?php
// /api-db/ia-instagram-profile-optimizer-fetch.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.', 'data' => null]);
    exit;
}

try {
    $business_id = 1; // Asumiendo business_info_id = 1
    
    // Buscar la columna 'ai_plan_json'
    $sql = "SELECT ai_plan_json FROM ia_instagram_profile_optimizer_results WHERE business_info_id = ?";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id]);
    
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result) {
        // $result ahora es ['ai_plan_json' => '...']
        // El JavaScript sabe cómo manejar esto.
        echo json_encode(['success' => true, 'message' => 'Plan de acción cargado.', 'data' => $result]);
    } else {
        // Esto es normal si no hay plan guardado.
        echo json_encode(['success' => true, 'message' => 'No se encontró ningún plan guardado.', 'data' => null]);
    }
    
} catch (Exception $e) {
    // Si la tabla no existe o algo más falla, esto lo captura.
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al buscar el plan: ' . $e->getMessage(), 'data' => null]);
}
?>