<?php
// /IAMarketing/api-db/ia-ideal-client-generator-update.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$business_id = 1; // Asumiendo business_info_id = 1

// A diferencia de otros 'update', este REQUIERE un ID
if (!isset($data['id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'No se proporcionó el ID del perfil a actualizar.']);
    exit;
}

// Validar campos
$required_keys = ['titulo_perfil', 'problema', 'deseo', 'frase_marketing', 'sugerencias', 'resumen_copiar'];
foreach ($required_keys as $key) {
    if (!isset($data[$key])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => "Faltan datos del perfil (clave: $key)."]);
        exit;
    }
}

try {
    $sql = "UPDATE ia_ideal_client_generator_results SET 
                titulo_perfil = ?, 
                problema = ?, 
                deseo = ?, 
                frase_marketing = ?, 
                sugerencias = ?, 
                resumen_copiar = ?
            WHERE id = ? AND business_info_id = ?"; // Doble seguridad
    
    $stmt = $pdo->prepare($sql);
    
    $sugerencias_json = json_encode($data['sugerencias']);
    
    $stmt->execute([
        $data['titulo_perfil'],
        $data['problema'],
        $data['deseo'],
        $data['frase_marketing'],
        $sugerencias_json,
        $data['resumen_copiar'],
        $data['id'], // ID del perfil específico
        $business_id // ID del negocio
    ]);
    
    echo json_encode(['success' => true, 'message' => 'Perfil de Cliente actualizado exitosamente.']);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al actualizar el Perfil: ' . $e->getMessage()]);
}
?>