<?php
// /api-db/ia-facebook-page-optimizer-create.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

// Espera un objeto 'ai_plan_json' que contiene el plan
if (isset($data['ai_plan_json'])) {
    $business_id = 1; // Asumiendo business_info_id = 1
    // Convierte el objeto/array del plan en un string JSON para guardarlo
    $ai_plan_string = json_encode($data['ai_plan_json']);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Error al codificar el plan JSON.']);
        exit;
    }

    try {
        // 1. Verificar si ya existe un registro
        $check_sql = "SELECT id FROM ia_facebook_page_optimizer_results WHERE business_info_id = ?";
        $check_stmt = $pdo->prepare($check_sql);
        $check_stmt->execute([$business_id]);
        
        if ($check_stmt->fetch(PDO::FETCH_ASSOC)) {
            http_response_code(409); // Conflicto
            echo json_encode(['success' => false, 'message' => 'Un plan de acción ya existe. Por favor, usa la función de actualizar.']);
            exit;
        }
        
        // 2. Insertar el nuevo registro
        $sql = "INSERT INTO ia_facebook_page_optimizer_results (business_info_id, ai_plan_json) VALUES (?, ?)";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$business_id, $ai_plan_string]);
        
        echo json_encode(['success' => true, 'message' => 'Plan de acción guardado exitosamente.']);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error de base de datos al crear el plan: ' . $e->getMessage()]);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'No se recibió el contenido del plan (ai_plan_json).']);
}
?>