<?php
// Incluimos la conexión a la base de datos desde la misma carpeta 'admin'
require_once 'db_admin-connection.php'; 

// Indicamos que la respuesta será en formato JSON
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// Obtener los parámetros de paginación de la solicitud GET
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 6; // Cantidad de promociones a devolver
$offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0; // Desde qué promoción empezar

// Asegúrate de que la variable global $pdo esté disponible
global $pdo; 

try {
    // Primero, obtener el número total de promociones
    $stmtCount = $pdo->prepare("SELECT COUNT(*) AS total FROM promotions");
    $stmtCount->execute();
    $totalPromotions = $stmtCount->fetch(PDO::FETCH_ASSOC)['total'];

    // Leemos la tabla 'promotions' con LIMIT y OFFSET para la paginación
    // Asegúrate de que las columnas coinciden con las de tu tabla 'promotions'
    $query = "SELECT product_name, description, price, image_url, purchase_url FROM promotions ORDER BY created_at DESC LIMIT :limit OFFSET :offset";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    
    $promotions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Preparar la respuesta incluyendo las promociones y el total
    $response = [
        'promotions' => $promotions,
        'total' => $totalPromotions,
        'current_count' => $offset + count($promotions) // Promociones cargadas hasta ahora
    ];

    echo json_encode($response);

} catch (PDOException $e) {
    http_response_code(500);
    error_log("Error en admin_promotions.php (PDO): " . $e->getMessage());
    echo json_encode(['error' => 'Error de conexión o consulta de base de datos']);
} catch (Exception $e) {
    http_response_code(500);
    error_log("Error inesperado en admin_promotions.php: " . $e->getMessage());
    echo json_encode(['error' => 'Error inesperado en el servidor']);
}
?>