<?php
// Incluimos la conexión a la base de datos desde la misma carpeta 'admin'
require_once 'db_admin-connection.php'; 

// Indicamos que la respuesta será en formato JSON
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// Asegúrate de que la variable global $pdo esté disponible
global $pdo; 

try {
    // Seleccionamos el banner más reciente con estado 'active'
    // Order by created_at DESC para obtener el más reciente, LIMIT 1 para solo uno.
    $stmt = $pdo->prepare("SELECT title, image_url, link_url FROM banners WHERE status = 'active' ORDER BY created_at DESC LIMIT 1");
    $stmt->execute();
    
    $banner = $stmt->fetch(PDO::FETCH_ASSOC); // Obtenemos una sola fila

    // Si no hay banners activos, devolvemos un objeto vacío o nulo
    if (!$banner) {
        echo json_encode(null); 
    } else {
        echo json_encode($banner);
    }

} catch (PDOException $e) {
    http_response_code(500);
    error_log("Error en admin_banners.php (PDO): " . $e->getMessage());
    echo json_encode(['error' => 'Error de conexión o consulta de base de datos']);
} catch (Exception $e) {
    http_response_code(500);
    error_log("Error inesperado en admin_banners.php: " . $e->getMessage());
    echo json_encode(['error' => 'Error inesperado en el servidor']);
}
?>